import logging
import os
import sys
from datetime import datetime


if "LOG_NAME" in os.environ:
    Execution_ID = os.environ["LOG_NAME"]
else:
    #TODO Add comments
    now = datetime.now()
    Execution_ID = "orphan_log_" + str(now.strftime("%d_%m_%y"))

_log_format = f"%(asctime)s-%(levelname)s::[%(filename)s-%(funcName)s-%(lineno)d] - %(message)s - [pid:%(process)s :: path:%(relativepath)s]"


class PackagePathFilter(logging.Filter):
    def filter(self, record):
        pathname = record.pathname
        if "logs" in pathname:
            record.relativepath = "logs" + pathname.split("logs")[1]
        else:
            record.relativepath = pathname
        return True


def get_file_handler(filename, path):
    """
    This function takes filename and path as parameter and creates a File Handler that
    :param filename:
    :param path:
    :return:
    """
    complete_path = path + "/" + filename + ".log"
    file_handler = logging.FileHandler(complete_path)
    file_handler.setLevel(logging.DEBUG)
    file_handler.addFilter(PackagePathFilter())
    file_handler.setFormatter(logging.Formatter(_log_format))
    return file_handler


def get_stream_handler():
    stream_handler = logging.StreamHandler()
    stream_handler.setLevel(logging.DEBUG)
    stream_handler.setFormatter(logging.Formatter(_log_format))
    return stream_handler


def get_logger(name, filename=Execution_ID):
    """
    It takes filename as input
    :param name:
    :param filename:
    :return:
    """
    try:
        logger = logging.getLogger(name)
        logger.setLevel(logging.DEBUG)
        current_directory = os.getcwd()
        default_log_path = current_directory.split("barapplication")[0] + "/barapplication/barapplication/logs/"
        if os.path.exists(default_log_path):
            if filename:
                logger.addHandler(get_file_handler(filename=filename, path=default_log_path))
            else:
                print("Please provide Filename, it is mandatory to start Logging")
        else:
            try:
                os.makedirs(default_log_path)
            except OSError:
                print(f'Error creating folder : {default_log_path}')
            else:
                print(f'Successfully created folder : {default_log_path}')
            if filename:
                logger.addHandler(get_file_handler(filename=filename, path=default_log_path))
            else:
                print("Please provide Filename, it is mandatory to start Logging")
        # If you want log to print on console uncomment below line
        # logger.addHandler(get_stream_handler())
        return logger
    except Exception as e:
        print(f"Exception Occured is : {e}")
        return None

