from barapplication.utilities.logger.source import get_logger
import requests
from rest_framework import authentication, permissions
from rest_framework.response import Response
from rest_framework.views import APIView
from rest_framework.authentication import TokenAuthentication

logger = get_logger(__name__)


class CustomGETAuthentication(authentication.BaseAuthentication):
    def authenticate(self, request):
        if request.method == 'GET':
            # Authenticate the GET request here using TokenAuthentication
            return TokenAuthentication().authenticate(request)
        return None


class EpgDataView(APIView):
    authentication_classes = [
        TokenAuthentication,
        CustomGETAuthentication,
        authentication.SessionAuthentication,
    ]
    # permission_classes = [permissions.IsAuthenticated]

    def get(self, request, *args, **kwargs):
        # Controller URL
        api_url = "http://mamba-daemon:8028/v1/epg"

        try:
            # Fetching EPG data from Controller
            response = requests.get(api_url)

            # Check if the request was successful (status code 200)
            if response.status_code == 200:
                logger.info("EPG response was successful")
                data = response.json()
                return Response(data)
            else:
                return Response(
                    {'error': 'Unable to fetch data from the external API'}, status=500
                )
        except requests.exceptions.RequestException as e:
            return Response({'error': f'Error: {str(e)}'}, status=500)
