# Generated by Django 4.2.5 on 2024-09-13 01:26

from django.db import migrations, models
import django.db.models.deletion
import tv_screens.models


class Migration(migrations.Migration):
    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="TvDetails",
            fields=[
                (
                    "id",
                    models.AutoField(
                        help_text="Unique ID for the TV",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        db_index=True,
                        help_text="Name of the TV",
                        max_length=100,
                        unique=True,
                    ),
                ),
                (
                    "description",
                    models.TextField(blank=True, help_text="Description of the TV"),
                ),
                (
                    "unique_id",
                    models.CharField(
                        blank=True,
                        help_text="Unique ID of the TV",
                        max_length=500,
                        null=True,
                        unique=True,
                    ),
                ),
                (
                    "serial_number",
                    models.CharField(
                        blank=True,
                        help_text="Serial number of the TV",
                        max_length=500,
                        null=True,
                        unique=True,
                    ),
                ),
                (
                    "ipaddress",
                    models.GenericIPAddressField(
                        help_text="IP address of the TV", unique=True
                    ),
                ),
                (
                    "port_number",
                    models.PositiveSmallIntegerField(
                        default=5000,
                        help_text="Port number of the TV",
                        validators=[tv_screens.models.validate_port_number],
                    ),
                ),
                (
                    "secret",
                    models.CharField(
                        blank=True,
                        help_text="Secret key (password) for the TV",
                        max_length=500,
                        null=True,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="TVExpectedStatus",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "channel_tmsid",
                    models.CharField(
                        default=None,
                        help_text="channel name that is tuned in TV",
                        max_length=100,
                        null=True,
                    ),
                ),
                (
                    "powered_on",
                    models.BooleanField(
                        choices=[(True, "On"), (False, "Off")],
                        default=None,
                        help_text="Should the TV Be powered on?",
                        null=True,
                    ),
                ),
                (
                    "muted",
                    models.BooleanField(
                        choices=[(True, "Muted"), (False, "Not Muted")],
                        default=None,
                        help_text="Should the TV Be muted?",
                        null=True,
                    ),
                ),
                (
                    "subtitles_enabled",
                    models.BooleanField(
                        choices=[(True, "Enabled"), (False, "Disabled")],
                        default=None,
                        help_text="Should the subtitles Be enabled?",
                        null=True,
                    ),
                ),
                (
                    "subtitles_language",
                    models.CharField(
                        default=None,
                        help_text="Subtitles language",
                        max_length=100,
                        null=True,
                    ),
                ),
                (
                    "cc_enabled",
                    models.BooleanField(
                        choices=[(True, "Enabled"), (False, "Disabled")],
                        default=None,
                        help_text="Should the Closed Captions Be enabled?",
                        null=True,
                    ),
                ),
                (
                    "volume",
                    models.PositiveSmallIntegerField(
                        default=None, help_text="Volume level", null=True
                    ),
                ),
                (
                    "tv_details",
                    models.OneToOneField(
                        help_text="Associated TV details",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="expected_status",
                        to="tv_screens.tvdetails",
                    ),
                ),
            ],
        ),
    ]
