from rest_framework.routers import DefaultRouter
from .views import TvDetailsViewSet, TV_ExpectedStatusViewSet, SiteGroupsTVsExpectedStatus, SetTvConfig, IdentifyTv
from django.urls import path, include

from rest_framework.routers import DefaultRouter, Route

router = DefaultRouter()
router.register(r'sites/(?P<site_id>\d+)/tv_screens', TvDetailsViewSet)



urlpatterns = [
    path('sites/<int:site_id>/tv_screens/<int:tv_id>/tvexpectedstatus/', TV_ExpectedStatusViewSet.as_view({'get': 'list'})),
    path('sites/<int:site_id>/tv_screens/tvexpectedstatus/', SiteGroupsTVsExpectedStatus.as_view()),
    path('sites/<int:site_id>/set_config', SetTvConfig.as_view()),
    path('sites/<int:site_id>/identify', IdentifyTv.as_view()),
    path('', include(router.urls)),
]
