from rest_framework import viewsets, status, decorators
from rest_framework.decorators import action
from rest_framework.response import Response
from rest_framework.authentication import SessionAuthentication, TokenAuthentication
from rest_framework.permissions import IsAuthenticated, AllowAny  
from django.contrib.auth.models import User
from rest_framework.authtoken.models import Token
from django.contrib.auth import authenticate


from .serializers import UserSerializer, UserSiteSerializer
from .models import UserSite


class UserSiteViewSet(viewsets.ModelViewSet):
    queryset = UserSite.objects.all()
    serializer_class = UserSiteSerializer
    authentication_classes = [SessionAuthentication, TokenAuthentication]
    #permission_classes = [IsAuthenticated]



class UserViewSet(viewsets.ModelViewSet):
    queryset = User.objects.all()
    serializer_class = UserSerializer
    authentication_classes = [SessionAuthentication, TokenAuthentication]
    permission_classes = [IsAuthenticated]

    @decorators.action(detail=False, methods=['POST'], permission_classes=[AllowAny])
    def signup(self, request):
        serializer = self.get_serializer(data=request.data)
        if serializer.is_valid():
            user = serializer.save()
            user.set_password(request.data['password'])
            user.save()
            token, created = Token.objects.get_or_create(user=user)
            return Response({"token": token.key, "user": serializer.data}, status=status.HTTP_201_CREATED)
        return Response(serializer.errors, status=status.HTTP_400_BAD_REQUEST)

    @decorators.action(detail=False, methods=['POST'], permission_classes=[AllowAny])
    def signin(self, request):
        username = request.data.get('username')
        password = request.data.get('password')
        
        if username and password:
            user = authenticate(username=username, password=password)
            if user is not None:
                token, created = Token.objects.get_or_create(user=user)
                serializer = self.get_serializer(instance=user)
                return Response({"token": token.key, "user": serializer.data}, status=status.HTTP_200_OK)
            else:
                return Response({"detail": "Invalid credentials"}, status=status.HTTP_401_UNAUTHORIZED)
        elif request.auth:
            return Response({"token": request.auth.key, "user": UserSerializer(request.user).data}, status=status.HTTP_200_OK)
        
        return Response({"detail": "Invalid request"}, status=status.HTTP_400_BAD_REQUEST)

    @action(detail=False, methods=['GET'])
    def test_token(self, request):
        return Response({f"Passed for {request.user.username}"})