# Generated by Django 4.2.5 on 2023-09-25 16:53

import django.contrib.postgres.fields
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("tv_screens", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="Sites",
            fields=[
                (
                    "id",
                    models.AutoField(
                        help_text="Unique ID for the site",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        db_index=True, help_text="Name of the site", max_length=100
                    ),
                ),
                ("description", models.TextField(help_text="Description of the site")),
                (
                    "epg_datasource",
                    models.CharField(
                        help_text="EPG data source for the site", max_length=500
                    ),
                ),
                (
                    "controller_details",
                    models.CharField(
                        help_text="Controller details for the site", max_length=500
                    ),
                ),
                (
                    "favourite_channels",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.CharField(blank=True, null=True),
                        blank=True,
                        help_text="List of favorite channels for the site",
                        null=True,
                        size=None,
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "Sites",
            },
        ),
        migrations.CreateModel(
            name="Group",
            fields=[
                (
                    "id",
                    models.AutoField(
                        help_text="Unique ID for the group",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        db_index=True, help_text="Name of the group", max_length=100
                    ),
                ),
                ("description", models.TextField(help_text="Description of the group")),
                (
                    "parent_group",
                    models.ForeignKey(
                        blank=True,
                        help_text="Parent group (if any)",
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="child_groups",
                        to="sites.group",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        help_text="Site to which the group belongs",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="groups",
                        to="sites.sites",
                    ),
                ),
                (
                    "tvs",
                    models.ManyToManyField(
                        blank=True,
                        help_text="TVs associated with the group",
                        related_name="groups",
                        to="tv_screens.tvdetails",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "Groups",
            },
        ),
    ]
