from rest_framework import serializers
from .models import Sites, Group
from tv_screens import serializers as tv_serializers


class SitesSerializer(serializers.ModelSerializer):
    class Meta:
        model = Sites
        fields = '__all__'
    
    def create(self, validated_data):
        site = super().create(validated_data)
        Group.objects.get_or_create(
            site=site,
            name=f"Unassigned",
            defaults={"description": "Default group for the site"}
        )
        return site


class GroupSerializer(serializers.ModelSerializer):
    class Meta:
        model = Group
        fields = '__all__'


class SiteTvsField(serializers.RelatedField):
    """Provides set of tvs through groups related to the target site"""

    def get_queryset(self, value):
        from tv_screens.models import TvDetails

        return (
            TvDetails.objects.filter(
                groups__site=value,
            )
            .order_by('unique_id')
            .prefetch_related('expected_status')
            .all()
        )

    def to_representation(self, value):
        from tv_screens.serializers import TvDetailsDaemonSerializer

        return TvDetailsDaemonSerializer(value, many=True).data


class SiteDaemonSerializer(serializers.ModelSerializer):
    class Meta:
        model = Sites
        fields = ['site_id', 'devices']

    site_id = serializers.IntegerField(source='id')
    devices = SiteTvsField(source='get_tvs')
