"""
URL configuration for barapplication project.

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/4.2/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  path('', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  path('', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.urls import include, path
    2. Add a URL to urlpatterns:  path('blog/', include('blog.urls'))
"""
from django.contrib import admin
from django.urls import path, include, re_path
from drf_yasg import openapi
from rest_framework import permissions
from drf_yasg.views import get_schema_view as yasg_get_schema_view

schema_view = yasg_get_schema_view(
    openapi.Info(
        title="MMBA Django API Documentation",
        default_version='v1',
        description="This api is developed as part of mmba. It is mainly used to serve the data for mmba gui.",
        terms_of_service="https://www.google.com/policies/terms/",
        contact=openapi.Contact(email="mmba@atx.com"),
        license=openapi.License(name="MIT License"),
    ),
    public=True,
    permission_classes=[permissions.AllowAny],
)

urlpatterns = [
    path('admin/', admin.site.urls),
    path('api/v1/',include("tv_screens.urls")),
    path('api/v1/',include("guide.urls")),
    path('api/v1/userauth/',include("userauth.urls")),
    path('api/v1/',include("sites.urls")),
    re_path(r'^swagger/$', schema_view.with_ui('swagger', cache_timeout=0), name='schema-swagger-ui'),
    re_path(r'^redoc/$', schema_view.with_ui('redoc', cache_timeout=0), name='schema-redoc'),

]
