from django_assets import Bundle, register
from django.conf import settings

polyfills = Bundle(
    # "js/vendor/object_keys.js",  # object_keys() workaround for IE missing Object.keys
    # "js/vendor/object_assign.js",  # IE Polyfill
    # "js/vendor/array_from.js",  # IE Polyfill
    # "js/vendor/array_find.js",  # IE Polyfill
    # "js/vendor/array_findindex.js",  # IE Polyfill
    # "js/vendor/string_endswith.js",  # IE Polyfill
    "js/vendor/number.js",  # provide .isNaN and isFinite
    "js/vendor/arrayindexof.js",  # provide .indexof
    "js/vendor/promise-7.0.4.min.js",  # IE polyfill
    filters="uglifyjs",
    output="js/polyfills-%(version)s.js",  # should likely be "%(product)s-%%(version)s"%settings
)
register('js_polyfills', polyfills)

js = Bundle(
    polyfills,
    "js/vendor/jquery-1.7.1.min.js",
    "js/vendor/jquery.cookie.js",
    "js/vendor/dayjs/dayjs.min.js",  # provide date manipulation support
    "js/vendor/moment.min.js",
    "js/vendor/moment-timezone.js",
    # "js/vendor/jquery-ui-1.8.18.custom.min.js",
    "js/vendor/jquery.ba-outside-events.min.js",  # click-off-to-cancel
    "js/vendor/jquery.miniColors.js",  # color selector, EPG config
    "js/clockskewwarning.js",  # header warning about clock not matching client machine
    "js/timer.js",  # timer with register/cancel functions
    "js/media.js",  # big hodge-podge of formatting mechanisms
    "js/statuspoll.js",  # periodic-polling operation
    "js/formerrors.js",  # render form errors from js into traditional forms
    "js/toggleboxes.js",  # render check-box as a toggle
    "js/filltemplate.js",  # fill out an HTML template from JS structures, HTML-attribute based
    "js/ui.js",  # this is pulled in from the *product*
    # Adding an upstream project something here?
    # Did you add your asset to atxstyle/atxstyle/views.py:asset_metadata ?
    filters="uglifyjs",
    output="js/atx-%(version)s.js",  # should likely be "%(product)s-%%(version)s"%settings
)
register('js_atx', js)

jquery_ui_js = Bundle(
    'js/vendor/jquery-ui-1.8.18.custom.min.js',
    'js/vendor/jquery.ui.timepicker.js',
    'js/vendor/jquery.ui.datetime.js',
    'js/vendor/jquery.ui.widget.js',
    filters="uglifyjs",
    output='js/jquery-ui-%(version)s.js',
)
jquery_ui_css = Bundle(
    "css/jquery-ui-1.8.18.custom.css",
    "css/jquery.miniColors.css",
    'css/jquery.ui.timepicker.css',
    filters='cssmin',
    output='css/jquery-ui-%(version)s.css',
)
register('js_jquery_ui', jquery_ui_js)
register('css_jquery_ui', jquery_ui_css)

logviewer = Bundle(
    "js/logviewer.js", filters="uglifyjs", output="js/logviewer-%(version)s.js"
)
register('js_logviewer', logviewer)

base_css = Bundle(
    "css/atxlayout.css",
    "css/cards.css",
    "css/factoryonly.css",
    "css/forms.css",
    "css/lights.css",
    "css/lists.css",
    "css/logs.css",
    "css/longshort.css",
    "js/reactloading/loading.css",
    "css/messages.css",
    "css/overallheader.css",
    "css/primarytable.css",
    "css/intents.css",
    "css/fileupload.css",
    "css/legacy.css",
    "css/buttons.css",
    "css/licenseclientsummary.css",
    "css/layout.css",
    filters='cssmin',
)
upstream_css = Bundle(
    # CSS which is not re-minimized, just concatenated
    "css/font-awesome.min.css",
    "css/grid-simple.css",
    "css/pure-release-0.6.0/pure-min.css",
    "css/pure-release-0.6.0/grids-responsive-min.css",
)
main_css = Bundle(
    upstream_css,
    base_css,
    output="css/atx-%(version)s.css",
)
register('css_main', main_css)

css_encprofile = Bundle(
    "css/analyzeresults.css",
    "css/iconcolumn.css",
    "css/objectnesting.css",
    "css/reactforms.css",
    "css/spinner.css",
    "css/statefuldropdown.css",
    "css/statusgraph.css",
    "css/statustable.css",
    "css/videooverlay.css",
    "css/quicksettings.css",
    "css/multichannelaudio.css",
    "css/encprofile.css",
    "css/fieldlayout.css",
    "css/cryptfilter.css",
    filters="cssmin",
    output="css/encprofile-%(version)s.css",
)
register('css_encprofile', css_encprofile)

system_js = Bundle(
    jquery_ui_js,
    Bundle(
        "js/system.js",
        filters=[
            "uglifyjs",
        ],
    ),
    output="js/system-%(version)s.js",
)
register('js_system', system_js)
system_css = Bundle(
    jquery_ui_css,
    Bundle(
        "css/system.css",
        filters=[
            "cssmin",
        ],
    ),
    output="css/system-%(version)s.css",
)
register('css_system', system_css)

logview_js = Bundle(
    jquery_ui_js,
    Bundle(
        "js/logviewer.js",
    ),
    output="js/logviewer-%(version)s.js",
)
register('logview_js', logview_js)
