from __future__ import print_function
from django.conf import settings
import logging 
log = logging.getLogger( __name__ )
from atxstyle.djmigrate import get_app
from django.contrib.contenttypes.models import ContentType
from django.contrib.auth import models as auth_models

def get_model( name ):
    app,cls_name,pname = name.split('.',2)
    return getattr( get_app( app ), cls_name ), pname

def get_permission( name ):
    model,pname = get_model( name )
    ct = ContentType.objects.get_for_model( model )
    try:
        perm = auth_models.Permission.objects.get(
            codename = pname,
            content_type =ct,
        )
    except auth_models.Permission.DoesNotExist:
        perm = auth_models.Permission.objects.create(
            codename = pname,
            name = " ".join( pname.title().split('_')),
            content_type = ct,
        )
    return perm

def default_password(username,company=None,product=None):
    if product is None:
        if hasattr( settings, 'PRODUCT_FAMILY'):
            product = settings.PRODUCT_FAMILY 
        else:
            product = settings.PRODUCT
    if company is None:
        company = getattr(settings,'COMPANY_SHORT_NAME','atx')
    return '%s_%s_%s_password'%(company.lower(),product.lower(),username.lower())


def default_user( username ):
    from django.contrib.auth import hashers
    from atxstyle import utctime
    log.info("Creating new user: %s",username)
    user = auth_models.User.objects.create(
        username = username,
        email = '%s@example.com'%(username,),
        password = hashers.make_password( 
            default_password(username),
        ),
        last_login = utctime.current_utc(),
    )
    return user

def base_permissions(create_missing_users=True):
    for username,record in settings.DEFAULT_PERMISSIONS.get( 'users',{}).items():
        try:
            user = auth_models.User.objects.get( username=username )
        except auth_models.User.DoesNotExist:
            user = default_user(username)
        user.user_permissions.clear()
        for full_pname in record.get( 'permissions',[] ):
            perm = get_permission( full_pname )
            user.user_permissions.add( perm )
        user.save()
    for groupname,grouprecord in settings.DEFAULT_PERMISSIONS.get( 'groups', {} ).items():
        try:
            group = auth_models.Group.objects.get( name = groupname )
        except auth_models.Group.DoesNotExist:
            log.info( 'Creating new group %s', groupname )
            group = auth_models.Group.objects.create(
                name = groupname 
            )
        group.permissions.clear()
        for full_pname in grouprecord.get( 'permissions',[] ):
            perm = get_permission( full_pname )
            group.permissions.add( perm )
        group.save()
        for username in grouprecord.get( 'users',[] ):
            print('adding %s to group %s'%(username,group))
            try:
                user = auth_models.User.objects.get( username=username )
            except auth_models.User.DoesNotExist:
                log.error( 'You need to `django-admin loaddata virgin_data` then re-run this command, (missing user %s)', username )
                continue # next user...
            else:
                user.groups.add( group )
                user.save()

