"""Django login based authentication"""
from atxstyle import defaultsettings
defaultsettings.setup_default()
import os, sys, logging, json
from django.contrib.auth import authenticate
from atxstyle import models as atx_models
from django.http import HttpRequest
log = logging.getLogger(__name__)

def get_options():
    import argparse
    parser = argparse.ArgumentParser(
        description='Check login name against django users usage `vada-check-login username` with PASSWORD in environment',
    )
    parser.add_argument(
        'username',
        help='Username to validate/verify',
    )
    return parser

def main():
    options = get_options().parse_args()
    from django.contrib import auth
    request = HttpRequest()
    password = os.environ.get('PASSWORD')
    user = authenticate(request, username=options.username, password=password)
    if user is None:
        log.warning(
            'Failed Login for %r', options.username
        )
        raise SystemExit(1)
    else:
        print(json.dumps(atx_models.user_schedule_json(user)))
        return 0

