#! /usr/bin/env python3
import os, shutil, sys
from fussy import nbio


def sudo(command):
    return nbio.Process(command)().decode('utf-8')


def get_options():
    import argparse

    parser = argparse.ArgumentParser(description='Strips source code from firmware')
    parser.add_argument('killfile', default='killfile.globs')
    return parser


def main():
    options = get_options().parse_args()
    target_python = 'python%s.%s' % tuple(sys.version_info[:2])
    killfile = options.killfile
    full_path = '/opt/firmware/current'

    for path in open(killfile):
        path = path.strip()
        if path.startswith('#'):
            continue
        else:
            sudo('rm -rf %(full_path)s/%(path)s' % locals())
        for localedir in sudo(
            'find %(full_path)s -name "locale"' % locals()
        ).splitlines():
            unsupported_locales = " ".join(
                sudo(
                    'ls -I "en*" -I "*.py?" -I "*.py" %(localedir)s' % locals()
                ).split()
            )
            if unsupported_locales:
                sudo('cd %(localedir)s && rm -rf %(unsupported_locales)s' % locals())
        # compile and strip...

        legacy_mode = '-b' if target_python.startswith('python3') else ''
        sudo(
            '%(full_path)s/env/bin/%(target_python)s -m compileall %(legacy_mode)s -q %(full_path)s/env/lib/%(target_python)s/site-packages || /bin/true'
            % locals()
        )
        # work around pysnmp's mib-cache problems
        sudo(
            'rm -rf junk-does-not-exist $(find %(full_path)s/env/lib/%(target_python)s/site-packages -name "*.py" | grep -v migrations | grep -vi mibs)'
            % locals()
        )
        sudo(
            'rm -rf junk-does-not-exist $(find %(full_path)s/env/lib/%(target_python)s/site-packages -name "*.pyc" | grep -ie "migrations\|mibs")'
            % locals()
        )
        # clean out pycache directories...
        sudo(
            'rm -rf junk-does-not-exist $(find %(full_path)s/env/lib/%(target_python)s/site-packages -name "__pycache__")'
            % locals()
        )
