import logging, time,os
from fussy import twrite
log = logging.getLogger(__name__)
def mark_south_finished(settings):
    """Set flag that we have finished the final south migration for this product?"""
    filename = os.path.join( 
        settings.VAR_DIRECTORY,
        'last_south_migration',
    )
    if not os.path.exists( filename ):
        content = time.strftime('%Y-%m-%d %H:%M:%S')
        if settings.MODIFY_SYSTEM:
            twrite.twrite( filename, content+'\n' )
        else:
            log.warning("Not marking system migrated (source release)" )
        return content
    else:
        return open( filename ).read()

def south_finished(settings=None):
    """Have we finished the final south migration?
    
    Returns the (string) date on which we did the migration
    """
    if settings.PRODUCT != 'digistream':
        # only digistream still has any machines needing final migration off django 1.6
        return True
    filename = os.path.join( 
        getattr(settings,'VAR_DIRECTORY','/var/firmware/'),
        'last_south_migration',
    )
    if os.path.exists( filename ):
        return open(filename).read()
    return None

def get_app( app_name ):
    """Get app's model module by app_name"""
    try:
        from django.apps import apps
        return apps.get_app_config(app_name).models_module
    except ImportError:
        from django.db.models import get_app
        return get_app( app_name )
    

def update_all_contenttypes(**kwargs):
    from django.apps import apps
    from django.contrib.contenttypes.management import update_contenttypes
    for app_config in apps.get_app_configs():
        update_contenttypes(app_config, **kwargs)
