"""Base code for ATXStyle product factory resets"""
import os, logging, glob
from django.conf import settings
from osupdates import prestart
from atxstyle import licenseclient, encryption, uniquekey
from fussy import nbio
log = logging.getLogger( __name__ )

class BaseReset( object ):
    TO_DELETE = [
        os.path.join( settings.VAR_DIRECTORY, 'firmware','*' ),
        os.path.join( settings.VAR_DIRECTORY, 'etc','*' ),
        os.path.join( settings.VAR_DIRECTORY, 'log','*' ),
        os.path.join( settings.VAR_DIRECTORY, 'run','*' ),
        os.path.join( settings.VAR_DIRECTORY, 'run','scheduler','*' ),
        os.path.join( settings.VAR_DIRECTORY, 'media','event-log.json*' ),
        os.path.join( settings.VAR_DIRECTORY, 'media','upgrade-progress.log' ),
        os.path.join( settings.VAR_DIRECTORY, 'media','ringbuffer','*' ),
        os.path.join( settings.VAR_DIRECTORY, 'upload','*' ),
        os.path.join( settings.RUN_DIRECTORY, '*'),
        os.path.join(settings.PROTECTED_DIR,'reversion-unchanged'),
        os.path.join( '/etc', settings.PRODUCT, 'django-secret.conf' ),
        '/etc/nginx/keys/server.key',
        '/etc/nginx/keys/server.crt',
        licenseclient.CURRENT_CERTIFICATE_FILE,
        licenseclient.CURRENT_LICENSES_FILE,
        licenseclient.CURRENT_SERVER_CONFIG,
        '/var/log/*.gz',
        '/var/log/*.1',
        '/var/log/nginx/*',
        '/var/log/supervisor/*',
        '/home/*/tmp',
        '/home/*/*.deb',
        '/home/*/sideloads/source_files/*.deb*'
        '/var/firmware/arcos/3screens/log/*',
        '/var/firmware/arcos/3screens/core',
    ]

    def cleanup_files(self):
        """What logs do we want to kill? Most of them..."""
        for cleanup in self.TO_DELETE:
            for file in glob.glob( cleanup ):
                try:
                    if os.path.isfile( file ):
                        log.info( 'Deleting %s', file )
                        os.remove( file )
                except Exception as err:
                    log.warning( 'Unable to delete %s: %s', file, err )
        nbio.Process( 'apt-get clean' )()
    def new_keys(self):
        prestart.create_secret_key(settings.PRODUCT, settings.PRODUCT if settings.PRODUCT != 'epgdata' else 'digistream')
        prestart.create_ssl_certs()
        encryption.create_gpg_cert(ownership='root:root')
    
    def cleanup(self):
        uniquekey.calculate_keys()
        self.cleanup_files()
        self.new_keys()

