import logging,os
log = logging.getLogger(__name__)

class CleanupMixin( object ):
    """Mixin providing cleanup of non-SHARED sinks"""
    def fitting_cleanup( self ):
        """Do our pre-deletion cleanup of fitting-related records
        
        Note: this is *only* the cleanup to be performed when the 
        instance is deleted from the db, the change has *not* yet
        been published to the back-end.
        
        Just adding a pre_delete *won't* work, as the connections
        have already been cleaned up by a pre_delete in fitting,
        so that pre_delete has a hook that runs this method...
        """
        if os.environ.get('RESTORE_IMPORT'):
            log.info("Skipping cleanups during restore/import")
            return
        try:
            for sink in self.sinks():
                if not getattr( sink,'SHARED',True ):
                    log.info("Deleting dependent %s(pk=%s) from %s",sink.__class__.__name__,sink.pk,self)
                    try:
                        sink.delete()
                        log.info("Completed deletion of %s(pk=%s)",sink.__class__.__name__,sink.pk )
                    except Exception:
                        log.exception("Failure deleting %s",sink)
                else:
                    log.info("Non-shared sink %r", sink )
        except Exception:
            log.exception( 'Failure attempting to cleanup %s', self )
