import netifaces, logging
from optparse import OptionParser
from twisted.protocols.ftp import FTPFactory, FTPRealm
from twisted.cred.portal import Portal
from twisted.cred.checkers import AllowAnonymousAccess
from twisted.internet import reactor
from atxstyle import standardlog
log = logging.getLogger( __name__ )

def get_options():
    parser = OptionParser()
    parser.add_option( 
        '-i','--interface', 
        dest='interface', 
        default='eth1', 
        help="Interface on which to listen",
    )
    parser.add_option(
        '-p','--port',
        dest = 'port',
        default=2121,
        type="int",
        help="Port on which to listen",
    )
    parser.add_option(
        '-r', '--root',
        dest = 'root',
        default='/var/firmware/ftp',
        help = "Root directory to serve",
    )
    return parser

def main(args=None):
    standardlog.enable()
    options,args = get_options().parse_args(args)
    address = netifaces.ifaddresses( options.interface ).get( 
        netifaces.AF_INET 
    )[0]['addr']
    
    log.info( 'Serving %s on %s:%s (%s)', options.root, address, options.port, options.interface )
    
    p = Portal(FTPRealm(options.root),
               [AllowAnonymousAccess()])

    f = FTPFactory(p)
    reactor.listenTCP(options.port, f, interface=address)
    reactor.run()

if __name__ == "__main__":
    main()
