#! /usr/bin/env python
"""Script to generate ISO 639-2 lookup file from Library of Congress data-file"""
import os, requests, json
from fussy import twrite
HERE = os.path.abspath(os.path.dirname(__file__))
URL = 'http://www.loc.gov/standards/iso639-2/ISO-639-2_utf-8.txt'

def main():
    target_file = os.path.join(HERE, 'iso6392.json')
    source_file = os.path.join(HERE, 'iso6392.csv')
    if not os.path.exists(source_file):
        response = requests.get(URL)
        if response.ok:
            # have to strip off the UTF-8 BOM
            twrite.twrite(source_file, response.content[3:])
        else:
            response.raise_for_status()
    languages = []
    for line in open(source_file).read().splitlines():
        line = line.split('|')
        key, name = line[0], line[3]
        if key == 'eng':
            assert name == 'English',  name 
        languages.append([key, name])
        
    languages.sort(key=lambda x:x[1])
    twrite.twrite(target_file, json.dumps(languages))
    return target_file

if __name__ == "__main__":
    main()
    
            
