import time
MINUTE = 60
HOUR = MINUTE*60
DAY = HOUR*24
WEEK = DAY*7
def time_ago( ts ):
    """How long ago was timestamp?"""
    seconds = time.time() - ts
    if seconds > WEEK:
        return time.strftime('%Y-%m-%d %H:%M', time.localtime(ts))
    return human_duration( seconds ) + ' ago'

def human_duration( seconds ):
    seconds = abs( seconds )
    result = []
    if seconds > DAY:
        days = int(seconds // DAY)
        result.append( '%s day%s'%(days,['s',''][days==1],))
        seconds = seconds % DAY
    if seconds > HOUR:
        hours = int(seconds // HOUR)
        result.append( '%s hour%s'%(hours,['s',''][hours==1],))
        seconds = seconds % HOUR 
    if len(result) < 2 and seconds > MINUTE :
        minutes = int(seconds // MINUTE)
        result.append( '%s minute%s'%(minutes,['s',''][minutes==1],))
        seconds = seconds % MINUTE 
    if not result:
        seconds = int(round(seconds,0))
        result.append( '%s second%s'%(seconds,['s',''][seconds==1],))
    return " ".join( result )

SUFFIXES = [['PB',1024*1024*1024*1024*1024],['TB',1024*1024*1024*1024],['GB',1024*1024*1024],['MB',1024*1024],['KB',1024]]
def human_bytes( count,places=1 ):
    for suffix,size in SUFFIXES:
        if count >= size:
            return '%%0.%if%s'%(places,suffix)%(count/float(size))
    return '%sB'%(count,)
