#! /bin/bash
"""Create a scaled and sized image for target"""
from __future__ import print_function
from optparse import OptionParser

def get_options():
    parser = OptionParser()
    parser.add_option( 
        '--width', 
        dest='width', 
        default=1280, 
        type="int",
        help="Target width",
    )
    parser.add_option( 
        '--height', 
        dest='height', 
        default=720, 
        type="int",
        help="Target height",
    )
    parser.add_option(
        '-s', '--source',
        dest='source',
        default = None,
        help = 'Source file',
    )
    parser.add_option(
        '-t', '--target',
        dest='target',
        default = None,
        help = 'Target file (default is based on source file)',
    )
    return parser

def target_file( name, width, height ):
    name += '-%(width)sx%(height)s'%locals()
    return name
    
def create( source, target, width, height ):
    """Create image based on source that is widthxheight"""
    from PIL import Image, ImageOps
    image = Image.open( source )
    format = image.format
    image.thumbnail((width,height), Image.ANTIALIAS )
    if image.size != (width,height):
        background = Image.new( 'RGB', (width,height), (0,0,0))
        background.paste( 
            image, 
            ((width-image.size[0])//2,(height-image.size[1])//2)
        )
        image = background
    image.save( target, format )
    return image

def main(args=None):
    parser = get_options()
    options,args = parser.parse_args(args)
    if args and not options.source:
        options.source = args[0]
        args = args[1:]
    if args and not options.target:
        options.target = args[0]
        args = args[1:]
    if not options.source:
        parser.error( 'Need a source file' )
        return 1
    if not options.target:
        options.target = target_file( options.source, options.width, options.height )
    create( options.source, options.target, options.width, options.height )
    print(options.target)
    return 0

if __name__ == "__main__":
    main()
