'''IPv6 address support routines'''
from atxstyle.sixish import unicode
import ipaddress

def is_ipv6(ip):
    try:
        return ipaddress.ip_address(unicode(ip)).version == 6
    except Exception:
        return False


def is_ipv6_link_local(ip):
    try:
        addr = ipaddress.ip_address(unicode(ip))
        if addr.version == 6:
            return addr.is_link_local
    except Exception:
        pass

    return False


def url_host_from_ip(ip):
    if is_ipv6(ip):
        return '[{}]'.format(ip)

    return ip
