"""Decorator to require a given license before continuing..."""
import os, logging, time
from functools import wraps
from atxstyle import licenseclient, utctime
log = logging.getLogger( __name__ )

def current_passes_function( test_function ):
    return test_function( licenseclient.current() )
def wait( duration ):
    time.sleep( duration )

def mtime_or_0( filename ):
    if not os.path.exists( filename ):
        return 0 
    else:
        return os.stat( filename ).st_mtime
    
def wait_for_changes( filename=None, poll_period=10 ):
    """Yield event for each write to the license directory"""
    filename = filename or licenseclient.CURRENT_LICENSES_FILE
    mtime = mtime_or_0( filename )
    while mtime_or_0( filename ) == mtime:
        wait( poll_period )

def wait_for_passes( test_function, description ):
    while not current_passes_function( test_function ):
        log.warning( 'Currently unable to find %s, waiting', description )
        wait_for_changes( )

def with_required_license( test_function, description='required license' ):
    """Watch licenses file waiting until test_function passes on loaded json
    
    test_function( license_structure ) -> boolean True/False 
    
        If True, then the function should proceed
    """
    def _with_license_required( base ):
        @wraps( base )
        def with_required_license( *args, **named ):
            wait_for_passes( test_function, description )
            return base( *args, **named )
        return with_required_license
    return _with_license_required

def has_license_test( key ):
    """Simple test to see if we have a license of the given type"""
    def has_license( structure ):
        for license in structure.get('verified',[]):
            if license.get('type') == key:
                if license.get( 'valid_until' ) >= utctime.current_utc().strftime('%Y-%m-%d %H:%M:%S'):
                    return license 
        return None 
    has_license.__name__ = 'has_license_'+key 
    return has_license
