from __future__ import print_function
from django.core.management.base import BaseCommand
#from django.conf import settings
from optparse import make_option
import logging 
log = logging.getLogger( __name__ )
#from django.contrib.auth import models as auth_models
from atxstyle.djmigrate import get_app
from django.contrib.contenttypes.models import ContentType
from django.contrib.auth import models as auth_models
config_models = get_app( 'config' )

def get_model( name ):
    app,cls_name,pname = name.split('.',2)
    return getattr( get_app( app ), cls_name ), pname

def get_permission( name ):
    model,pname = get_model( name )
    ct = ContentType.objects.get_for_model( model )
    try:
        perm = auth_models.Permission.objects.get(
            codename = pname,
            content_type =ct,
        )
    except auth_models.Permission.DoesNotExist:
        perm = auth_models.Permission.objects.create(
            codename = pname,
            name = " ".join( pname.title().split('_')),
            content_type = ct,
        )
    return perm


class Command(BaseCommand):
    args = ''
    help = 'Sets/gets the system serial number'
    option_list = BaseCommand.option_list + (
        make_option(
            '-s','--serial',
            dest = 'serial',
            help='Set the serial number'
        ),
    )

    def handle(self, *args, **options):
        if options.get('serial'):
            # setting...
            for system in config_models.System.objects.all():
                system.serial_number = options.get('serial')
                system.save()
                break
        for system in config_models.System.objects.all():
            if system.serial_number:
                print(system.serial_number)
                break
