def moment_to_strftime(format):
    if not format:
        return format
    for replacement, result in [
        ('YYYY', '%Y'),
        (
            'yyyy',
            '%Y',
        ),  # it wasn't actually part of moment format, but we have settings with it
        ('YY', '%y'),
        ('yy', '%y'),
        # Note: in moment, M => month in strftime M => minute
        ('MMMM', '%B'),
        ('MMM', '%b'),
        ('MM', '%m'),
        ('M', '%-m'),
        ('DD', '%d'),
        ('D', '%-d'),
        ('dddd', '%A'),
        ('ddd', '%a'),
        ('dd', '%a'),
        (
            'd',
            '%-d',
        ),  # NOT actually what is in moment, but no-one wants day-of-week as integer...
        ('HH', '%H'),
        ('H', '%-H'),
        ('hh', '%I'),
        ('h', '%-I'),
        ('mm', '%M'),
        ('m', '%-M'),
        ('ss', '%s'),
        ('s', '%-s'),
        ('zz', '%Z'),
        ('z', '%Z'),
        ('ZZ', '%z'),
        ('Z', '%z'),
        ('A', '%p'),
        ('a', '%p'),
    ]:
        fragments = format.split(replacement, 1)
        if len(fragments) > 1:
            return (
                moment_to_strftime(fragments[0])
                + result
                + moment_to_strftime(fragments[1])
            )
    return format
