#! /usr/bin/env python
"""Script to track IGMP behaviour"""
import logging,time,json
log = logging.getLogger(__name__)

VIF = '/proc/net/ip_mr_vif'
CACHE = '/proc/net/ip_mr_cache'
PERIOD = 10 # seconds

OUTFILE = 'multicast-status.log'
def pairs( sequence ):
    yield 
def hex_group( group_as_hex ):
    result = []
    for start in range(6,-2,-2):
        result.append( '%d'% int(group_as_hex[start:start+2],16))
    return '.'.join(result)
def read_vif( filename = VIF ):
    result = {}
    for line in open( filename ).read().strip().splitlines()[1:]:
        line = line.strip().split()
        record = dict(
            id = int(line[0]),
            name=line[1],
            in_count = int(line[2]),
            out_count = int(line[3]),
        )
        result[record['name']] = record 
    return result
def read_cache( filename=CACHE ):
    result = {} # group: record
    for line in open( filename ).read().splitlines()[1:]:
        line = line.strip().split()
        try:
            out_vifs = list(set([int(x,10) for x in line[6].split(':')]))
        except IndexError:
            out_vifs = []
        record = dict(
            group = hex_group(line[0]),
            source = hex_group(line[1]),
            vif = int(line[2],10),
            bytes = int(line[4],10),
            out_vifs = out_vifs,
        )
        result[ record['group']] = record
    return result

def main():
    logging.basicConfig(level=logging.INFO)
    log.info("Writing to: %s",OUTFILE)
    while True:
        log.info("Checking")
        vif = read_vif()
        cache = read_cache()
        with open( OUTFILE, 'ab') as fh:
            fh.write( 
                time.strftime('%Y-%m-%d %H:%M:%S ')
            )
            fh.write(
                json.dumps( {'vif':vif,'cache':cache} )
            )
            fh.write('\n')
        time.sleep( PERIOD )
        
if __name__ == "__main__":
    main()
