"""Stupid little module to introspect networking config from current"""
import psutil
import netaddr
from fussy import nbio

def gateway():
    line = nbio.Process('ip route | grep ^default')().decode('utf-8').strip().split()
    address = line[2]
    device = line[4]
    return (device,address)
    

def debian_from_current():
    """Build a debian networking configuration from the current configuration"""
    gateway_dev,gateway_address = gateway()
    lines = [
        'auto lo',
        'iface lo inet loopback',
        '',
    ]
    for name,addresses in psutil.net_if_addrs().items():
        if name == 'lo': continue
        elif name.startswith('veth'): continue
        lines.append('auto %(name)s'%locals())
        for binding in addresses:
            if binding.family in (2,10): # ipv4,ipv6
                protocol = 'inet' if binding.family == 2 else 'inet6'
                if binding.address:
                    address = binding.address.split('%')[0]
                    addr = netaddr.IPAddress( address )
                    if addr.is_link_local():
                        continue 
                else:
                    continue
                lines.append( 'iface %(name)s %(protocol)s static'%locals())
                lines.append( '  address %(address)s'%locals())
                if binding.netmask:
                    netmask = binding.netmask 
                    lines.append( '  netmask %(netmask)s'%locals())
                if name == gateway_dev:
                    lines.append( '  gateway %(gateway_address)s'%locals())
        lines.append( '' )
    lines.append( '' )
    return '\n'.join( lines )
def main():
    print( debian_from_current())
