"""Convenience wrapper around Django's Paginator
https://docs.djangoproject.com/en/dev/topics/pagination/

Essentially, this module aims to rid the user of the repetitive mechanics
around pagination in views.

Usage:
    paginator = SimplePaginator()
    paginator.get_data_for_page(page)
"""

from django.core.paginator import Paginator, PageNotAnInteger, EmptyPage


class SimplePaginator:
    def __init__(self, *args, **kwargs):
        self.paginator = Paginator(*args, **kwargs)
    
    def get_data_for_page(self, page_num):
        """Regardless of input: page_num, ensure we always return a object of -
        django.core.paginator.Page
        We are essentially encapsulating the repetitive try-except into a single
        method call.
        """
        try:
            data = self.paginator.page(page_num)
        except PageNotAnInteger:
            data = self.paginator.page(1)
        except EmptyPage:
            data = self.paginator.page(self.paginator.num_pages)
        return data
