"""Generate simple random passwords

(c) Mike C. Fletcher, MIT License
"""
import string, secrets as random, os 

def crypt_512(pw):
    import crypt
    return crypt.crypt( pw, '$6$'+password(20))

def password(length=15,charset=string.ascii_letters+string.digits):
    """Generate a simple password using the secrets module"""
    return ''.join([
        random.choice(charset)
        for i in range(length)
    ])

def get_options():
    import argparse 
    parser = argparse.ArgumentParser(description='Create a password')
    parser.add_argument(
        '-l','--length',
        help='Password length to use',
        default = 15,
        type = int,
    )
    return parser

def main():
    options = get_options().parse_args()
    value = password(length=options.length)
    print( value, crypt_512(value))