"""Script to write periodic-boot entry to the cron.d directory"""
from fussy import twrite, nbio
import os, sys

HEADER = '''# ATX Style periodic reboot cron-job
# Auto-generated by the atxstyle system module
# do not edit.
'''

FILENAME = '/etc/cron.d/atx-scheduled-reboot'
TEMPLATES = {
    1: '%(minute)s %(hour)s * * * root /sbin/reboot\n',
    2: '%(minute)s %(hour)s * * 0 root /sbin/reboot\n',
    0: '',
}

def main():
    period,hour,minute = [int(x,10) for x in sys.argv[1:4]]
    if not period in TEMPLATES:
        return 2
    template = TEMPLATES.get( period )
    content = template %locals()
    if content:
        content = HEADER + content
    if content:
        twrite.twrite( FILENAME, content )
    else:
        if os.path.exists( FILENAME ):
            try:
                os.remove( FILENAME )
            except Exception as err:
                pass 
    nbio.Process( 'touch /etc/cron.d' )()
