"""Execute code required to add PostGIS setup to a database

Create an empty migration::

    django-admin schemamigration --empty project

Then in the migration::

    from atxstyle import postgissetup

    ...
    
        postgissetup.install( db )

Assumes Ubuntu 12.04 server
"""
import os
from fussy import nbio

def install( 
    db, 
    pg_version = '9.1',
    postgis_version='1.5',
    path = '/usr/share/postgresql/%(pg_version)s/contrib/postgis-%(postgis_version)s',
):
    directory = path %locals()
    for filename in ('postgis.sql','spatial_ref_sys.sql'):
        filename = os.path.join( directory, filename )
        nbio.Process( 'sudo -n -u postgres psql -d %(db)s -f %(filename)s'%locals())()
    _sql( db, "GRANT ALL ON geometry_columns TO PUBLIC;" )
    _sql( db, "GRANT ALL ON spatial_ref_sys TO PUBLIC;" )
    _sql( db, "GRANT ALL ON geography_columns TO PUBLIC;" )

def _sql( db, command ):
    nbio.Process( 'sudo -n -u postgres psql -d %(db)s -c %(command)r'%locals())()

