#! /usr/bin/env python
"""Operation to do a power-cycle on a server"""
from fussy import nbio
import time, logging, glob
from atxstyle.sixish import long, unicode, as_unicode, as_bytes
log = logging.getLogger(__name__)

VENDOR_FILE = '/sys/devices/virtual/dmi/id/board_vendor'

def use_ipmi():
    return glob.glob( '/dev/ipmi*' )

def get_options():
    import argparse
    parser = argparse.ArgumentParser( description='Power-cycle system with rtc or ipmi')
    parser.add_argument(
        '--rtc',
        action = 'store_true',
        default = False,
        help = 'Force use of Real-time-clock even if IPMI is present',
    )
    return parser

def ipmi_cycle():
    time.sleep(1)
    log.info("Issuing ipmi power cycle")
    nbio.Process([
        'ipmitool','power','cycle',
    ])()
def rtc_cycle():
    nbio.Process([ 'hwclock', '--systohc' ])()
    with open( '/sys/class/rtc/rtc0/wakealarm','wb' ) as fh:
        fh.write(b'0') # clear any current wake alarms
    with open( '/sys/class/rtc/rtc0/wakealarm', 'wb' ) as fh:
        fh.write( as_bytes(str(long( time.time()+30)))) # write time to wake...
    time.sleep(1)
    log.info("Issuing halt")
    nbio.Process( ['halt','-f','-p'])()

def main():
    logging.basicConfig(level=logging.INFO)
    options = get_options().parse_args()
    if (not options.rtc) and use_ipmi():
        ipmi_cycle()
        return 0 
    else:
        rtc_cycle()
        return 0
