from atxstyle import defaultsettings

defaultsettings.setup_default()
import json
from urllib.parse import quote_plus
from django.conf import settings

FORMAT = 'postgres://%(USER)s:%(PASSWORD)s@%(HOST)s:%(PORT)s/%(NAME)s'


def main():
    result = {}
    for name, db in settings.DATABASES.items():
        db = db.copy()
        if '@' in db['USER']:  # AZURE email-like names
            db['USER'] = quote_plus(db['USER'])
        result[name] = FORMAT % db
    print(json.dumps(result, indent=2))
