from __future__ import print_function
from atxstyle import loadoptions

def load_options( package ):
    """Load the options module from package"""
    final = '%s.options'%(package,)
    __import__(final,{},{},final.split('.'))
    return loadoptions.DOCUMENTATION

def get_options():
    import argparse
    parser = argparse.ArgumentParser( description='Prints the options for a given module')
    parser.add_argument(
        'package',
        help='Name(s) of the package for which to display the options',
        nargs='+',
        default='vadagst',
    )
    return parser 

def main():
    options = get_options().parse_args()
    for package in options.package:
        load_options(package)
    content = []
    for (section,keys) in sorted(loadoptions.DOCUMENTATION.items()):
        content.append(section)
        content.append('-'*len(section))
        for key,description in sorted(keys.items()):
            content.append(key)
            dl = []
            default = description.get('default')
            if default is not None:
                dl.append('*default* %s'%(default,))
            current = description.get('current')
            if current != default:
                dl.append('*current* %s'%(default,))
            doc = description.get('__doc__')
            if doc is not None:
                dl.extend( doc.splitlines())
            content.extend(['    %s'%(l,) for l in dl])
    print('\n'.join(content))

if __name__ == "__main__":
    main()
