import time


class Profiler:
    """Basic profiler to output (via a logger instance) time elapsed between
    start and done calls.
    Accepts a message to be printed in the done method.
    Recommend usage is to instantiate a Profiler instance once, and call start/
    stop multiple times when needed.
    """
    def __init__(self, logger, level_func='debug'):
        self.logger = logger
        self.start_time = 0
        self.level_func = level_func

    def start(self):
        self.start_time = time.time()

    def done(self, msg):
        _msg = '-P- {} --> {}'.format(msg, time.time() - self.start_time)
        getattr(self.logger, self.level_func)(_msg)
