"""Interface to the Numato USB Powered Relay device (via PySerial)"""
from fussy import twrite, cronlock, nbio
from atxstyle import asuser
import logging, json, os
import argparse
FILENAME = '/var/firmware/run/reboot-required.json'
LOCK_FILE = FILENAME + '.lock'
log = logging.getLogger(__name__)

def set( reason, filename=FILENAME ):
    """Set the flag, adding reason to set of reasons"""
    directory = os.path.dirname( filename )
    if not os.path.exists( directory ):
        with asuser.AsUser( sudo_user = True ):
            try:
                os.makedirs( directory )
            except (IOError,OSError):
                # race condition
                pass
    LOCK = cronlock.BlockingLock( filename+'.lock', lock_wait=5 )
    with LOCK:
        current = get(filename=filename)
        current['reboot'] = True
        if reason:
            reasons = current.get('reasons',[])
            if reason not in reasons:
                reasons.append(reason)
            current['reasons'] = reasons
        with asuser.AsUser( sudo_user = True ):
            twrite.twrite(filename,json.dumps(current))
        return current

def get(filename=FILENAME):
    try:
        return json.loads(open(filename).read())
    except Exception:
        return {}

def clear(filename=FILENAME):
    LOCK = cronlock.BlockingLock( filename+'.lock', lock_wait=15 )
    with LOCK:
        try:
            os.remove(filename)
        except (OSError,IOError):
            pass

def do():
    if get().get('reboot'):
        nbio.Process(['reboot'])()

def set_options():
    parser = argparse.ArgumentParser(description='Set reboot required from the command line')
    parser.add_argument(
        'reason',help='Text describing the reason in user-accessible terms',
    )
    return parser
def set_main():
    options = set_options().parse_args()
    set(options.reason)
def clear_main():
    parser = argparse.ArgumentParser(description='Clear the reboot-required flag (file)')
    options = parser.parse_args()
    clear()
def do_main():
    parser = argparse.ArgumentParser(description='If we need to reboot, perform a reboot')
    options = parser.parse_args()
    do()
