#! /home/mcfletch/atx-dev/gui-env/bin/python
from __future__ import print_function
from atxstyle import defaultsettings
defaultsettings.setup_default()
from fussy import nbio
from atxstyle import tui
import logging, time,traceback
import os 
os.environ['PATH'] = os.pathsep.join([ x for x in [
    '/sbin/','/usr/sbin','/bin','/usr/bin',
    '/opt/firmware/current/env/bin', 
    os.environ.get('PATH'),
] if x])
log = logging.getLogger( __name__ )

def reboot():
    try:
        nbio.Process( 'sudo -n /sbin/reboot &' )()
    except Exception:
        # shouldn't happen, even if we *can* run the process, as we've spawned 
        # a separate process...
        tui.current().show_text_body( traceback.format_exc(), 'Reboot Failure' )
    time.sleep( 5 )

def iface( ip, netmask ):
    names = [
        line.split(':')[1].strip()
        for line in nbio.Process( 'ip link show | grep UP | grep -v LOOP | grep -v POINTOPOINT' )().decode('utf-8').splitlines()
        if line.strip()
    ]
    def run_function( interface ):
        def run_with_interface( *args, **named ):
            return apply_iface( interface, ip, netmask )
        return run_with_interface
    return tui.run_menu( [
        {
            'label': 'Interface %s'%(n),
            'function': run_function( n ),
        }
        for n in names 
    ] + [
        {
            'function': tui.exit_menu,
            'label': 'Cancel',
        }
    ], title="Choose Interface" )

def apply_iface( interface, ip, netmask ):
    interface = interface.split('@')[0]
    try:
        nbio.Process( 'sudo -n /sbin/ifconfig %s down'%(interface) )()
    except Exception as err:
        pass
    print('Configuring %(interface)s for %(ip)s/%(netmask)s'%locals())
    try:
        nbio.Process( 'sudo -n /sbin/ifconfig %(interface)s %(ip)s netmask %(netmask)s up'%locals() )()
    except nbio.ProcessError:
        print("Unable to configure")
    else:
        print('Configured')
    
def iface_192():
    return iface( '192.168.0.23', '255.255.255.0' )
def iface_10():
    return iface( '10.10.10.45', '255.255.0.0' )
def iface_172():
    return iface( '172.168.8.45', '255.255.0.0' )

def exit_and_reboot():
    """Exit the menu and perform a reboot"""
    reboot()
    tui.exit_menu()
    
def network_info():
    report = []
    for process in (
        'ip addr show',
        'route -n',
    ):
        try:
            report.append( nbio.Process(process)().decode('utf-8'))
        except nbio.ProcessError:
            report.append( 'Unable to run: %s'%process )
    tui.current().show_text_body( '\n'.join( report ), 'Network Info' )


PRIVATE_NETWORK_MENU = [
    {
        'function': iface_192,
        'label': '192.168.0.23/24',
    },
    {
        'function': iface_10,
        'label': '10.10.10.45/16',
    },
    {
        'function': iface_172,
        'label': '172.16.8.45/16',
    },
    {
        'function': tui.exit_menu,
        'label': 'Cancel',
    },
]
