"""Python 2/3 compatibility layer"""
try:
    unicode = unicode
    raw_input = raw_input
except NameError:
    unicode = str
    raw_input = input
try:
    long = long
except NameError:
    long = int
import functools


def as_bytes(value, encoding='utf-8'):
    if isinstance(value, unicode):
        value = value.encode(encoding)
    elif not isinstance(value, bytes):
        value = str(value)
        if isinstance(value, unicode):
            value = value.encode(encoding)
    return value


def as_unicode(value, encoding='utf-8'):
    if isinstance(value, bytes):
        value = value.decode(encoding)
    elif not isinstance(value, unicode):
        value = unicode(value)
    return value


def as_text(value, encoding='utf-8'):
    """As native text type for type-changed apis"""
    if str is unicode:
        return as_unicode(value, encoding)
    else:
        return as_bytes(value, encoding)


def subs_lru_cache(maxsize):
    """Simplified version of LRU cache for mostly-single-threaded operation"""

    def wrapper(func):
        cache = {}
        sentinel = object()

        @functools.wraps(func)
        def with_cache(*args, **named):
            key = args + tuple(sorted(named.items()))
            value = cache.get(key, sentinel)
            if value is sentinel:
                cache[key] = value = func(*args, **named)
            return value

        return with_cache

    return wrapper


if not hasattr(functools, 'lru_cache'):
    lru_cache = subs_lru_cache
else:
    lru_cache = functools.lru_cache
