"""Trivial utility functions for parsing the output of snmpbulkwalk

Requires ``-O f`` flag to snmpbulkwalk to get the expected format...
"""
from __future__ import unicode_literals
from collections import namedtuple
import logging 
from atxstyle.sixish import as_unicode
log = logging.getLogger( __name__ )
__all__ = ['parse','TypedHolder']

def convert_int( v ):
    if '(' in v:
        return int( v.split('(')[1].rstrip(')'), 10)
    return int(v,10)
def convert_str( v ):
    return v.strip().strip('"')
def convert_ip( v ):
    return v

def clean_value( value ):
    value = value.strip()
    if value.startswith( 'No more variables left' ):
        raise IndexError( value )
    if value.startswith( 'Wrong Type' ):
        raise TypeError( "Wrong Data-type returned, likely using the wrong MIB: %s"%( value, ))
    for typ,convert in [
        ("INTEGER", convert_int),
        ("STRING", convert_str),
        ("IpAddress", convert_ip),
        ("Gauge32", convert_int),
        ("Counter32", convert_int),
    ]:
        if ':' in value and value.startswith( typ + ':' ):
            value = value[len(typ)+1:].strip()
            return typ,convert( value )
    if value == '""':
        return 'STRING',''
    return 'STRING',value

TypedHolder = namedtuple( 'TypedHolder', ['value','type'] )

def parse( status, strip_prefix='.iso.org.dod.internet.private.enterprises' ):
    """Parse the output of status into properties"""
    properties = {}
    status = as_unicode( status )
    strip_prefix = as_unicode( strip_prefix )
    for line in status.strip().splitlines():
        if line.startswith( strip_prefix ):
            line = line[len(strip_prefix):]
        key,value = line.split('=',1)
        key = key.strip()
        try:
            typ,value = clean_value( value )
        except IndexError as err:
            continue 
        except TypeError as err:
            err.args += (line,)
            raise
        if key not in properties:
            properties[key] = TypedHolder( value,typ )
    return properties
