from __future__ import absolute_import
import logging
from atxstyle.sixishdj import url, include
from django.conf import settings
from atxstyle.decorators import log_login_failures

try:
    # Django 1.x
    from django.contrib.auth.views import login
except ImportError:
    # Django 2.x
    from django.contrib.auth.views import LoginView

    login = LoginView.as_view(template_name='login.html')

from django.contrib.auth.views import logout_then_login

from atxstyle import license_urls
from netconfig import urls as netconfig_urls
from ipfilter import urls as ipfilter_urls
from sysemail import urls as sysemail_urls
from atxstyle import views, system, user_urls
from reactforms import storagemap
from atxstyle import reactforms, producttheme

log = logging.getLogger(__name__)

urlpatterns = [
    # Examples:
    url(
        r'^ptheme/(?P<remainder>[-./a-zA-Z0-9]+)$',
        producttheme.theme_url,
        name='product_theme_url',
    ),
    url(r'^license/', include(license_urls)),
    url(r'^netconfig/', include(netconfig_urls)),
    url(r'^ipfilter/', include(ipfilter_urls)),
    url(r'^system/processes/$', views.processes, name='processes'),
    url(r'^system/certs/$', views.license_client, name='license_client'),
    url(r'^system/raid/$', system.raid, name='system_raid'),
    url(
        r'^system/support-download/$', system.support_download, name='support_download'
    ),
    url(r'^system/email/', include(sysemail_urls)),
    url(
        r'^accounts/login/',
        log_login_failures(login),
        name='login',
        kwargs=dict(
            template_name='login.html',
        ),
    ),
    url(r'^accounts/logout/', logout_then_login, name='logout', kwargs=dict()),
    url(r'^accounts/', include(user_urls)),
    url(r'^log/events$', views.eventlog, name='eventlog'),
    url(
        r'^log/upgrade$',
        views.log,
        {
            'name': 'System Upgrade',
            'log': 'upgrade-progress',
            'debug': False,
        },
        name='upgrade_log',
    ),
    url(
        r'^log/raw/(?P<log>[-a-zA-Z0-9]+(?:[.][a-z0-9]+)?)$',
        views.log_data,
        name='log_data',
    ),
    url(
        r'^api/system_status_json', views.system_status_json, name='system_status_json'
    ),
    url(r'^api/storage_map', storagemap.storage_mapping, name='storage_url_map'),
    url(r'^system/errtest/$', views.err, name='err_test'),
    url(
        r'^api/lockouts_status_json',
        views.lockouts_status_json,
        name='lockouts_status_json',
    ),
    url(
        r'^api/system_logs_json/(?P<log>[a-zA-Z0-9_-]+)?$',
        views.system_logs_json,
        name='system_logs_json',
    ),
    url(
        r'^api/system_os_status_json/$',
        views.system_os_status_json,
        name='system_os_status_json',
    ),
    url(
        r'^api/system_licenses_json/$',
        views.system_licenses_json,
        name='system_licenses_json',
    ),
    url(
        r'^api/system_licenses_json/(?P<package>[a-zA-Z0-9_.-]+)?$',
        views.system_licenses_json,
        name='system_licenses_json_package',
    ),
    url(
        r'^api/system_licenses_json/(?P<package>[a-zA-Z0-9_.-]+)/(?P<license>[a-zA-Z0-9_.-]+)?$',
        views.system_licenses_json,
        name='system_licenses_json_license',
    ),
    url(r'^factory/serial/$', views.factory_serial, name='factory_serial'),
    url(
        r'^factory/license_clear/$',
        views.factory_license_clear,
        name='factory_license_clear',
    ),
] + reactforms.REGISTRY.url_fragments(
    'system_forms', required_permission='passportgui.view_config'
)

if 'tacacsauth' in settings.INSTALLED_APPS:
    from tacacsauth import urls as tacacs_urls

    urlpatterns += [
        url(r'^tacacs/', include(tacacs_urls)),
    ]
if 'ldapauth' in settings.INSTALLED_APPS:
    from ldapauth import urls as ldap_urls

    urlpatterns += [
        url(r'^ldap/', include(ldap_urls)),
    ]

if 'restore' in settings.INSTALLED_APPS:
    from restore import urls as restore_urls

    urlpatterns += [
        url(r'^restore/', include(restore_urls)),
    ]
if 'django.contrib.admin' in settings.INSTALLED_APPS:
    from django.contrib import admin
    from django.shortcuts import redirect

    def admin_redirect(request):
        return redirect('/admin/')

    urlpatterns += [
        url(r'^admin/redirect/', admin_redirect, name='admin'),
        url(r'^admin/', admin.site.urls),
    ]

if settings.DEBUG:
    try:
        import debug_toolbar
    except ImportError:
        log.debug("Django Debug Toolbar is not installed")
    else:
        urlpatterns += [
            url(r'^__debug__/', include(debug_toolbar.urls)),
        ]

    if 'django.contrib.staticfiles' in settings.INSTALLED_APPS:
        # serve static content *only* in debug mode...
        from django.views import static

        urlpatterns += [
            url(
                settings.STATIC_URL.lstrip('/') + '(?P<path>.*)$',
                static.serve,
                {'document_root': settings.STATIC_ROOT},
            ),
            url(
                settings.MEDIA_URL.lstrip('/') + '(?P<path>.*)$',
                static.serve,
                {
                    'document_root': settings.MEDIA_ROOT,
                },
            ),
        ]

for (k, name) in {
    'system_status': 'system_status_json',
    'system_lockouts': 'lockouts_status_json',
    'system_forms': 'system_forms',
    'system_licenses': 'system_licenses_json',
    'system_os_status': 'system_os_status_json',
}.items():
    storagemap.register_storage(k, name)
