import logging
log = logging.getLogger(__name__)
from atxstyle import control
STATE_LOCK = control.WithLock()

class StateTracker( object ):
    """Provides state tracking"""
    def __init__(self, states, error_states=None, initial=None):
        with STATE_LOCK:
            self.states = states
            self.error_states = error_states or set()
            self.state_map = dict(states)
            self.current = set()
            if initial:
                self.add(*initial)
    def clear(self):
        self.current.clear()
    def add(self,*states):
        with STATE_LOCK:
            for state in states:
                if not state in self.state_map:
                    raise ValueError(state,self.state_map.keys())
                self.current.add( state )
        #log.debug("Current states: %s",", ".join(sorted(self.current)))
    def __contains__(self,key):
        return key in self.current
    def remove(self,*states):
        with STATE_LOCK:
            for state in states:
                try:
                    self.current.remove( state )
                except KeyError:
                    pass
    def status_json(self):
        states,messages,error = [],[],False
        for k,v in self.states:
            if k in self.current:
                states.append(k)
                messages.append(v)
                if k in self.error_states:
                    error = True
        return {
            'error': error,
            'states': states,
            'messages': messages,
        }
    def __repr__(self):
        return str(self.status_json())
