import React from "react";
import {FontAwesomeIcon} from "faicon";

describe("FontAwesomeIcons rendering", () => {
    it("Includes tooltips when passed",() => {
        const component = render(<FontAwesomeIcon name='moo' title='A tooltip' />);
        expect(component).to.have.attr('title','A tooltip');
    });
    it("Sets the fa and fa-* classes",() => {
        const component = render(<FontAwesomeIcon name='moo' title='A tooltip' />);
        expect(component).to.have.className('fa');
        expect(component).to.have.className('fa-moo');
    });
});