/* Warn user about system clock not agreeing with client clock */
$(document).ready( function() {
    "use strict";
    var warn_skew = 60;
    var err_skew = 120;
    $('.system-time-display' ).each( function() {
        var display = $(this);
        var warning = display.find( '.system-time-warning' );
        var product = warning.find( '.product-name' ).text();
        var system_time_str = display.attr( 'data-timestamp' );
        if (system_time_str) {
            var system_time = parseFloat( system_time_str );
            var client_time = Math.round((new Date()).getTime() / 1000);
            var delta = system_time - client_time;
            var delta_abs = Math.abs( delta );
            if (delta_abs > warn_skew) {
                warning.find( '.which-behind' ).text( (delta < 0) ? product:'Management PC' );
                warning.find( '.delta' ).text( ''+Math.round(delta_abs,0) );
                warning.show();
                if (delta_abs > err_skew) {
                    display.addClass( 'error' );
                } else {
                    display.addClass( 'warning' );
                }
            }
        }
    });
});
