import React from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import { withRouter } from 'react-router';

import { withStyles } from '@material-ui/core/styles';
import AppBar from '@material-ui/core/AppBar';
import Toolbar from '@material-ui/core/Toolbar';
import {Link} from 'react-router-dom';
import Breadcrumbs from '@material-ui/core/Breadcrumbs';
import { with_focus } from 'dash/focusprovider';

import MuiButton from './MuiButton';
import MuiTypography from './MuiTypography';
import { getActiveRoute } from 'navigationUtils';
import { requiring_store } from '../r/storages/requiringstore';
import { default_user_storage_callback } from 'storages/userstorage';
import DocumentTitle from 'dash/documenttitle';
import FocusLink from 'dash/focuslink';
import UserName from 'dash/username';
import { getActiveRoutes } from './navigationUtils';
import Config from 'config';

const styles = theme => ({
    appBar: {
        zIndex: theme.zIndex.drawer + 1,
        background: theme.palette.common.white,
        color: theme.palette.common.text,
        justifyContent: 'center'
    },
    appBarShift: {
        width: `100%`
    },
    logo: {
        height: '45px',
        marginRight: theme.spacing(2)
    },
    menuButton: {
        marginLeft: 12,
        marginRight: 36
    },
    menuButtonHidden: {
        display: 'none'
    },
    title: {
        flexGrow: 1
    },
});

class AppHeader extends React.Component {
    render() {
        const { classes, location, routes, base_url, focus, match } = this.props;

        const activeRoutes = getActiveRoutes(routes, location.pathname);
        const activeRoute = (activeRoutes && activeRoutes.length) ? activeRoutes[activeRoutes.length-1] : {
            title: Config.company_name
        };
        const title_prop = (activeRoute.title || activeRoute.header);
        var title = title_prop && (
            typeof title_prop === 'string' ? title_prop: title_prop(
                {'header':this,'route': activeRoute,'match': match, location: location, focus: focus}
            )
        );
        if (title===undefined || title === null) {
            title = 'Unknown Location';
        }
        const current_record = focus.get_focus();
        var ancestor_list = [];
        activeRoutes && activeRoutes.slice(1,activeRoutes.length-1).map((route,i) => {
            let parent = null;
            if (route.link_url) {
                parent = <Link key={`menu-$i`} to={route.link_url}>{route.title}</Link>;
            } else if (route.title) {
                parent = <div key={`menu-$i`}>{route.title}</div>;
            }            
            if (parent) {
                ancestor_list.push(parent);
            }
        });
        if (current_record && current_record.focus) {
            // console.info(`Re-rendering the header ${current_record.focus.__pk__}`);
            const {ancestors} = current_record.focus;
            if (ancestors) {
                ancestors.map((ancestor,i) => {
                    const url = ancestor.__url__ || ancestor.url;
                    if (url) {
                        ancestor_list.push(
                            <FocusLink focus_on={ancestor} key={`ancestor-${i}`} to={url} onClick={(evt)=> {
                                focus.set_focus(ancestor,url);
                            }}>{ancestor.title}</FocusLink>
                        );
                    } else {
                        ancestor_list.push(
                            <span>{ancestor.title}</span>
                        );
                    }
                });
            }
        }
        ancestor_list.push(<MuiTypography
            key='title'
            component="h5"
            variant="h5"
            color="inherit"
            noWrap
            classes={{}}
        >
            {title}
        </MuiTypography>);
        const trail = <Breadcrumbs aria-label="Breadcrumb" className={classes.title} classes={{}}>
            {ancestor_list}
        </Breadcrumbs>;


        return (
            <AppBar className={classNames(classes.appBar)} classes={{}}>
                <DocumentTitle title={title} />
                <Toolbar className={classes.toolbar} classes={{}}>
                    <Link key="home-link" to={base_url}><img
                        src="/ptheme/img/company-logo.svg"
                        alt={(Config.company_short_name)+" Logo (click to go to dashboard)"}
                        className={classes.logo}
                        title="Go to Dashboard"
                        onClick={() => focus.set_focus(focus.default_focus)}
                    /></Link>
                    {trail}
                    <UserName />
                </Toolbar>
            </AppBar>
        );
    }
}


AppHeader.propTypes = {
    base_url: PropTypes.string.isRequired,
    classes: PropTypes.object.isRequired,
};

const Component = with_focus(withRouter(withStyles(styles)(AppHeader)));

export default requiring_store(Component, {
    storage_key: 'system_accounts',
    create_function: default_user_storage_callback(),
    prop_function: (props, store) => ({ ...props, store })
});
