import React from 'react';
import PropTypes from 'prop-types';

import { stores } from 'storeregistry';
import { Route, Switch } from 'react-router';
import with_error_boundary from 'errorboundary';
import DashLayout from './dashlayout';
const CatchingRoute = with_error_boundary(Route);
import ProtectedRoute from 'dash/protectedroute';
import LicensesPage from 'dash/licenses/LicensesPage';

export const NoMatch = (props) => {
    return <div>404 not found on {props.history.location.pathname}</div>;
};

class AppRoutes extends React.Component {
    renderRoute(item) {
        const {routes,base_url} = this.props;
        const render_children = (props) => {
            const itemProps = item.props || {};
            const renderer = item.renderer || (props => {
                const Component = item.component;
                if (!Component) {
                    console.error(`Item ${JSON.stringify(item)} component was null`);
                }
                const params = (item.params && item.params(props))|| {};
                const base = <Component
                    key={item.path}
                    {...props}
                    {...itemProps}
                    {...params}
                />;
                return base;
            });
            let base = renderer(props);
            if (! item.public) {
                base = <ProtectedRoute protection_test={(props) => {
                    const { user } = props;
                    return user.has_permission('factory') || (
                        stores.system_status &&
                        stores.system_status.config &&
                        stores.system_status.config.system &&
                        stores.system_status.config.system.eula_accepted
                    );
                }} protected={base} protection_control={LicensesPage} />;
                base = <ProtectedRoute protection_test={(props) => {
                    return props.user.name;
                }} protected={base} />;
            }
            return base;
        };
        const dash_render = (props) => <DashLayout routes={routes} base_url={base_url} no_sidebar={item.no_sidebar}>
            {render_children(props)}
        </DashLayout>;
        // TODO: add context such that it's trivial/easy to find current rendered route component
        return (
            <CatchingRoute
                exact={!!item.exact}
                key={item.path}
                end={item.end}
                strict={item.strict}
                path={item.path}
                render={dash_render}
            />
        );
    }

    renderRoutes(routes) {
        return routes.reduce((allRoutes, page) => {
            const subRoutes = page.routes ? this.renderRoutes(page.routes) : [];
            return [...allRoutes, ...subRoutes, this.renderRoute(page)];
        }, []);
    }
    NoMatch = (props) => {
        const {routes,base_url} = this.props;
        return <DashLayout routes={routes} base_url={base_url} no_sidebar={false}>
            <NoMatch {...props} />
        </DashLayout>;
    }

    render() {
        return (
            <Switch>
                {this.renderRoutes(this.props.routes)}
                <CatchingRoute component={this.NoMatch} />
            </Switch>
        );
    }
}

AppRoutes.propTypes = {
    base_url: PropTypes.string.isRequired,
    routes:  PropTypes.arrayOf(PropTypes.shape({
        header: PropTypes.string.isRequired,
        path: PropTypes.string.isRequired,
        component: PropTypes.func.isRequired,
        routes: PropTypes.array,
    })).isRequired,
};

export default AppRoutes;
