import React from 'react';
import ReactDOM from 'react-dom';

import CssBaseline from '@material-ui/core/CssBaseline';
import { MuiThemeProvider } from '@material-ui/core/styles';
import { BrowserRouter as Router } from 'react-router-dom';

import AppContent from 'dash/AppContent';
// import AppHeader from 'dash/AppHeader';
// import AppSidebar from 'dash/AppSidebar';
import AppRoutes from 'dash/AppRouter';
import LoginView from 'dash/login';
import {FocusProvider,with_focus} from 'dash/focusprovider';
import theme from 'dash/theme';
import 'scss/atx-dash.scss';
import '../../fonts/materialicons.css';
import {
    withRouter
} from 'react-router-dom';
import { default_system_storage} from 'r/systemstorage';
import {Redirect} from 'react-router-dom';

const DEFAULT_CONFIG = {
    theme: theme,
};
default_system_storage();

const BaseApp = (config) => {
    const theme = theme || DEFAULT_CONFIG.theme;
    const {routes, base_url} = config;
    
    class App extends React.Component {

        render() {
            return (
                <MuiThemeProvider theme={theme}>
                    <Router>
                        <FocusProvider key='focus-provider' default_focus={config} default_url={config.login_redirect} >
                            <CssBaseline />
                            {}
                            <div
                                style={{
                                    display: 'flex',
                                    fontFamily: theme.typography.fontFamily,
                                    paddingTop: theme.toolbar.height
                                }}
                            >
                                <AppRoutes routes={routes} base_url={base_url||'/'} app_config={config} />
                            </div>
                        </FocusProvider>
                    </Router>
                </MuiThemeProvider>
            );
        }
        static install(element_id) {
            ReactDOM.render(<App />, document.getElementById(element_id));
        }
    }
    return App;
};
export default BaseApp;
