import React from 'react';
import PropTypes from 'prop-types';

import classNames from 'classnames';
import Card from '@material-ui/core/Card';
import CardActions from '@material-ui/core/CardActions';
import CardContent from '@material-ui/core/CardContent';
import { withStyles } from '@material-ui/core/styles';

const styles = theme => ({
    card: {
        margin: theme.spacing(2)
    }
});

function MuiCard(props) {
    const { classes, children, actions, fullWidth, className = '' } = props;

    return (
        <Card className={classNames(classes.card, className)}>
            {fullWidth}
            <CardContent>{children}</CardContent>
            {actions && <CardActions>{actions}</CardActions>}
        </Card>
    );
}

MuiCard.propTypes = {
    classes: PropTypes.object.isRequired
};

export default withStyles(styles)(MuiCard);
