import React from 'react';

import Dialog from '@material-ui/core/Dialog';
import DialogActions from '@material-ui/core/DialogActions';
import DialogContent from '@material-ui/core/DialogContent';
import DialogTitle from '@material-ui/core/DialogTitle';

import MuiButton from './MuiButton';

export default class MuiDialogue extends React.Component {
    handleClose = () => {
        if (this.props.onClose) {
            this.props.onClose();
        }
    };

    render() {
        const { title, children, open, actions } = this.props;

        return (
            <Dialog open={open} onClose={this.handleClose} {...this.props}>
                <DialogTitle>{title}</DialogTitle>
                <DialogContent>{children}</DialogContent>
                {actions && <DialogActions>{actions}</DialogActions>}
                {!actions && (
                    <DialogActions>
                        <MuiButton onClick={this.handleClose}>Close</MuiButton>
                    </DialogActions>
                )}
            </Dialog>
        );
    }
}
