import React from 'react';
import { withStyles } from '@material-ui/core/styles';
import Paper from '@material-ui/core/Paper';

const styles = theme => ({
    frameHolder: {
        minHeight: theme.spacing(45),
    },
    embedFrame: {
        width: '100%',
        minHeight: theme.spacing(45),
        border: 'none',
    }
});

class ProxyView extends React.Component {
    static defaultProps = {
        url: null
    };
    render() {
        const {classes,url} = this.props;
        return <div className={classes.frameHolder}><iframe
            className={classes.embedFrame}
            src={url}
            scrolling='no'
        ></iframe></div>;
    }
};

export default withStyles(styles)(ProxyView);
