import React from 'react';
import PropTypes from 'prop-types';

import MuiSnackbar from 'MuiSnackbar';
import {WithLockouts} from 'r/lockouts';

export class SystemLockout extends React.Component {
    static defaultProps = {
        lockouts: {}
    };

    render() {
        const { lockouts = {} } = this.props;

        if (!lockouts.error) {
            return null;
        }

        return (
            <MuiSnackbar variant="warning" stretch={true}>
                <div>System Locked, some operations disabled for the following reasons:</div>

                {lockouts.messages.map((message, i) => <div className="message" key={i}>{message}</div>)}
            </MuiSnackbar>
        );
    }
}
SystemLockout.propTypes = {
    lockouts: PropTypes.object
};

export default WithLockouts(SystemLockout);
