import React from 'react';

import { shallow } from 'enzyme';

import AppRoutes from 'dash/AppRouter';

const SomeComponent = () => <div />;

describe('AppRouter', () => {
    const setup = (propOverrides = {}) => {
        const props = {
            base_url: '/moo',
            routes: [
                {
                    'header': 'system',
                    'path': '/system/',
                    'component': SomeComponent,
                    'routes': [
                        {
                            'path': '/system/configuration/',
                            'header': 'Configuration',
                            'title': 'Configuration',
                            'component': SomeComponent,
                            'routes': [
                                {
                                    'path': '/system/configuration/nested/',
                                    'header': 'Configuration nested',
                                    'title': 'Configuration nested',
                                    'component': SomeComponent,
                                }
                            ]
                        },
                        {
                            'header': 'Dashboard',
                            'path': '/system/dashboard/',
                            'title': 'Dashboard',
                            'component': SomeComponent
                        },
                    ]
                }
            ],
            ...propOverrides
        };

        const wrapper = shallow(<AppRoutes {...props} />);

        return {
            props,
            wrapper,
            instance: wrapper.instance()
        };
    };
    
    it('renders a Switch', () => {
        const { wrapper } = setup();
        const Switch = wrapper.find('Switch');
        expect(Switch).to.have.lengthOf(1);
    });

    it('renders nested routes', () => {
        const { wrapper } = setup();
        const Routes = wrapper.find('ErrorBoundary');

        expect(Routes).to.have.lengthOf(4 + 1); // add 1 because of 404 route
        ['/system/configuration/nested/','/system/configuration/','/system/dashboard/','/system/'].map((path,index) => {
            expect(Routes.at(index).props().path).to.equal(path);
            expect(
                Routes.at(index).shallow().find('Route')
            ).to.have.lengthOf(1);
        });
    });

});
