import React from 'react';
import { shallow } from 'enzyme';

import TableBody from '@material-ui/core/TableBody';
import TableCell from '@material-ui/core/TableCell';
import TableHead from '@material-ui/core/TableHead';
import TableRow from '@material-ui/core/TableRow';

import MuiTable from 'dash/MuiTable';

describe('MuiTable', () => {
    const setup = (propOverrides = {}) => {
        const props = {
            config: {
                columns: [
                    {name: 'Name', key: 'name'},
                    {name: 'Age', key: 'age'},
                    {name: 'Job', get_value: item => item.job || 'Unknown'},
                ]
            },
            data: [
                {name: 'cosmo kramer', age: '40', job: null},
                {name: 'george costanza', age: '40', job: 'architect'},
                {name: 'jerry seinfeld', age: '40', job: 'comedian'},
            ],
            ...propOverrides
        };

        const wrapper = shallow(<MuiTable {...props} />);

        return {
            props,
            wrapper,
        };
    };

    it('renders the correct number of columns and rows', () => {
        const { wrapper, props } = setup();

        expect(wrapper.find(TableHead).find(TableCell)).to.have.lengthOf(props.config.columns.length);
        expect(wrapper.find(TableBody).find(TableRow)).to.have.lengthOf(props.data.length);
    });

    it('renders columns names', () => {
        const { wrapper, props } = setup();
        const column_names = wrapper.find(TableHead).find(TableCell).map(node => node.render().text());
        const expected_columns_names = props.config.columns.map(x => x.name);

        expect(column_names).to.deep.equal(expected_columns_names)
    });

    it('renders cell values', () => {
        const { wrapper, props } = setup();
        const kramer = wrapper.find(TableBody).find(TableRow).at(0);
        const values = kramer.find(TableCell).map(node => node.render().text());
        const expected_values = props.data.find(x => x.name === 'cosmo kramer');

        expect(values).to.deep.equal([
            expected_values.name,
            expected_values.age,
            'Unknown',
        ]);
    });
});
